/*
	0 = line
	1 = T
	2 = box
	3 = left L
	4 = right L
	5 = left Z
	6 = right Z
*/

//so each piece has 4 states (turning round) and has 4 parts which need co-ordinates...
//the coordinates are in order of anti-clockwise rotation
var isPlaying = false;
   	
var pieces = new Array(7);
//var high_scores = new Array(5);
var top_score = top_lines = 0;
var skin = "default";
var score = level = old_level = total_lines = max_row = 0; //points done as suggested by tugga from thedashboarder.com
var init_interval = 500, interval, debris = 0;
var grid_width = 16, grid_height = 32, box_dim = 7; //this is now done so that the size of dropper can be changed very easily. (miniDropper)

//this seems to be the only solution to making a 3d array... pieces[[[]]] would be nice :)
for (var i = 0; i < 7; i++) {
	pieces[i] = new Array(4);
	for (var a = 0; a < 4; a++) pieces[i][a] = new Array(4);  	
}

var grid = new Array(grid_height);
for (var i=0; i < grid.length; i++) {
	grid[i] = new Array(grid_width);
	for (var a=0; a < grid[i].length; a++) grid[i][a] = "b"; //for blank, since they'll be holding pointers to html elements if not blank...
}

//for (var i=0; i < high_scores.length; i++) high_scores[i] = 0;

//line: - DONE
	pieces[0][0][0] = new Pos(0,0);
	pieces[0][0][1] = new Pos(1,0);
	pieces[0][0][2] = new Pos(2,0);
	pieces[0][0][3] = new Pos(3,0);
	
	pieces[0][1][0] = new Pos(0,0);
	pieces[0][1][1] = new Pos(0,1);
	pieces[0][1][2] = new Pos(0,2);
	pieces[0][1][3] = new Pos(0,3);
	
	pieces[0][2][0] = new Pos(0,0);
	pieces[0][2][1] = new Pos(1,0);
	pieces[0][2][2] = new Pos(2,0);
	pieces[0][2][3] = new Pos(3,0);
	
	pieces[0][3][0] = new Pos(0,0);
	pieces[0][3][1] = new Pos(0,1);
	pieces[0][3][2] = new Pos(0,2);
	pieces[0][3][3] = new Pos(0,3);
	
	
//T: - DONE
	pieces[1][0][0] = new Pos(0,0);
	pieces[1][0][1] = new Pos(1,0);
	pieces[1][0][2] = new Pos(2,0);
	pieces[1][0][3] = new Pos(1,1);
	
	pieces[1][1][0] = new Pos(0,0);
	pieces[1][1][1] = new Pos(0,1);
	pieces[1][1][2] = new Pos(0,2);
	pieces[1][1][3] = new Pos(1,1);
	
	pieces[1][2][0] = new Pos(0,1);
	pieces[1][2][1] = new Pos(1,1);
	pieces[1][2][2] = new Pos(2,1);
	pieces[1][2][3] = new Pos(1,0);
	
	pieces[1][3][0] = new Pos(1,0);
	pieces[1][3][1] = new Pos(1,1);
	pieces[1][3][2] = new Pos(1,2);
	pieces[1][3][3] = new Pos(0,1);
	
//box: - DONE
	pieces[2][0][0] = new Pos(0,0);
	pieces[2][0][1] = new Pos(1,0);
	pieces[2][0][2] = new Pos(0,1);
	pieces[2][0][3] = new Pos(1,1);
	
	pieces[2][1][0] = new Pos(0,0);
	pieces[2][1][1] = new Pos(1,0);
	pieces[2][1][2] = new Pos(0,1);
	pieces[2][1][3] = new Pos(1,1);
	
	pieces[2][2][0] = new Pos(0,0);
	pieces[2][2][1] = new Pos(1,0);
	pieces[2][2][2] = new Pos(0,1);
	pieces[2][2][3] = new Pos(1,1);
	
	pieces[2][3][0] = new Pos(0,0);
	pieces[2][3][1] = new Pos(1,0);
	pieces[2][3][2] = new Pos(0,1);
	pieces[2][3][3] = new Pos(1,1);
	
//left L: - DONE
	pieces[3][0][0] = new Pos(0,1);
	pieces[3][0][1] = new Pos(1,1);
	pieces[3][0][2] = new Pos(2,1);
	pieces[3][0][3] = new Pos(2,0);
	
	pieces[3][1][0] = new Pos(0,0);
	pieces[3][1][1] = new Pos(1,0);
	pieces[3][1][2] = new Pos(1,1);
	pieces[3][1][3] = new Pos(1,2);
	
	pieces[3][2][0] = new Pos(0,0);
	pieces[3][2][1] = new Pos(0,1);
	pieces[3][2][2] = new Pos(1,0);
	pieces[3][2][3] = new Pos(2,0);
	
	pieces[3][3][0] = new Pos(0,0);
	pieces[3][3][1] = new Pos(0,1);
	pieces[3][3][2] = new Pos(0,2);
	pieces[3][3][3] = new Pos(1,2);
	
//right L: - DONE
	pieces[4][0][0] = new Pos(0,0);
	pieces[4][0][1] = new Pos(1,0);
	pieces[4][0][2] = new Pos(2,0);
	pieces[4][0][3] = new Pos(2,1);

	
	pieces[4][1][0] = new Pos(0,0);
	pieces[4][1][1] = new Pos(0,1);
	pieces[4][1][2] = new Pos(0,2);
	pieces[4][1][3] = new Pos(1,0);
	
	pieces[4][2][0] = new Pos(0,1);
	pieces[4][2][1] = new Pos(1,1);
	pieces[4][2][2] = new Pos(2,1);
	pieces[4][2][3] = new Pos(0,0);

   	
	pieces[4][3][0] = new Pos(1,0);
	pieces[4][3][1] = new Pos(1,1);
	pieces[4][3][2] = new Pos(1,2);
	pieces[4][3][3] = new Pos(0,2);
	
//left Z: - DONE
	pieces[5][0][0] = new Pos(0,0);
	pieces[5][0][1] = new Pos(1,0);
	pieces[5][0][2] = new Pos(1,1);
	pieces[5][0][3] = new Pos(2,1);
	
	pieces[5][1][0] = new Pos(1,0);
	pieces[5][1][1] = new Pos(1,1);
	pieces[5][1][2] = new Pos(0,1);
	pieces[5][1][3] = new Pos(0,2);
	
	pieces[5][2][0] = new Pos(0,0);
	pieces[5][2][1] = new Pos(1,0);
	pieces[5][2][2] = new Pos(1,1);
	pieces[5][2][3] = new Pos(2,1);
	
	pieces[5][3][0] = new Pos(1,0);
	pieces[5][3][1] = new Pos(1,1);
	pieces[5][3][2] = new Pos(0,1);
	pieces[5][3][3] = new Pos(0,2);
	
//right Z: - DONE
	pieces[6][0][0] = new Pos(0,1);
	pieces[6][0][1] = new Pos(1,1);
	pieces[6][0][2] = new Pos(1,0);
	pieces[6][0][3] = new Pos(2,0);
	
	pieces[6][1][0] = new Pos(0,0);
	pieces[6][1][1] = new Pos(0,1);
	pieces[6][1][2] = new Pos(1,1);
	pieces[6][1][3] = new Pos(1,2);
	
	pieces[6][2][0] = new Pos(0,1);
	pieces[6][2][1] = new Pos(1,1);
	pieces[6][2][2] = new Pos(1,0);
	pieces[6][2][3] = new Pos(2,0);
	
	pieces[6][3][0] = new Pos(0,0);
	pieces[6][3][1] = new Pos(0,1);
	pieces[6][3][2] = new Pos(1,1);
	pieces[6][3][3] = new Pos(1,2);

function Pos(x, y) {
	this.x = x;
	this.y = y;	
}

var piece, active_piece, active_piece_left, active_piece_top, cur_piece, cur_piece_state, piece_parts, top_layer = 0;
	
//this makes the piece which is shown in the next piece window - it is then 'yanked' into the playing part when needed and a new one created
function makePiece() {
	next_piece = Math.round(Math.random()*6); //this will be a random choice - although should be handled to show the next piece coming...

	piece = document.createElement("DIV");
	piece.className = "piece";
	
	//right - and now we'll position the pieces properly, so it looks nice...
	
	var p_top, p_left;
	
	switch(next_piece) {
		case 0:
			p_top = 5;
			p_left = 0;
			break;
		case 2:
			p_top = 0;
			p_left = 6;
			break;
		case 1:
		case 3:
		case 4:
		case 5:
		case 6:
			p_top = 0;
			p_left = 2;
			break;
	}
	
	piece.style.left = p_left + "px";
	piece.style.top = p_top + "px";
	
	for (var i=0; i < 4; i++) {
		var piece_part = document.createElement("SPAN");
		piece_part.className = "piece_part_" + next_piece;
		piece_part.style.top = (pieces[next_piece][0][i].y*box_dim) + "px";
		piece_part.style.left = (pieces[next_piece][0][i].x*box_dim) + "px";
		//piece_part.style.height = box_dim + "px";
		//piece_part.style.width = box_dim + "px";
		
		piece.appendChild(piece_part);
	}
	
	document.getElementById("next_piece").appendChild(piece);
}
   		
function yankPiece() { //takes the piece from the next piece screen and makes it the active one
	/*
		get all the pieces that have been used (this is used to check for a collision.
		doing it here so that we don't involve the active piece in our check - checking
		against itself would be a bit dumb):
    	so, now the position of the active piece is tracked globally, so I don't have to keep performing parseInt(piece.style.left) etc.
    */
    
    active_piece_left = (Math.floor(grid_width/2)-1)*box_dim; //64;
    active_piece_top = 0;

	piece.style.left = active_piece_left + "px";
	piece.style.top = active_piece_top + "px";
		
	document.getElementById("play_area").appendChild(piece);
	//document.getElementById("next_piece").removeChild(piece);
	
	active_piece = piece;
	cur_piece = next_piece;
	cur_piece_state = 0;
	
	piece_parts = active_piece.getElementsByTagName("SPAN");
	
	makePiece();
}
   		
function makeDebris() {
	for (var i=0; i < debris; i++) {
		//have between 4 and 7 pieces of debris on a row - this could change depending on difficulty level...
		var limit = Math.round(Math.random()*3) + 4;
		//alert(limit);
		
		for (var a=0; a < limit; a++) {
			var num = Math.round(Math.random()*(grid_width-1));
			//alert(num);
			
		//make the piece parts:
		/*
			fixing a bit of a bug/oversight whereby i didn't check to see if a piece was already there...
			having multiple pieces in one place would mean that only one of them was in the grid array 
			and so all the others would be left ethere... whoops :)
		*/	
		
			if (grid[i][num] == "b") {
				var piece_part = document.createElement("SPAN");
				piece_part.className = "piece_part_0";
				piece_part.style.top = (((grid_height-1)-i)*box_dim) + "px";
				piece_part.style.left = (num*box_dim) + "px";
				//piece_part.style.height = box_dim + "px";
				//piece_part.style.width = box_dim + "px";
			
				document.getElementById("play_area").appendChild(piece_part);
		
				grid[i][num] = piece_part; //f for filled...
			}
			
			//the above quick fix does mean that you can have 'doubling ups' in terms of num, but no doubled up elements.
			//just means you might have less debris on a line than expected, but who cares? it's random anyway :)
		}
   	}
}
   		
var canGoLeft = canGoRight = true;
   		
function movePiece(dir) {
   	//var l = parseInt(active_piece.style.left);
   	
	canGoLeft = true; //just resetting these (doing it here rather than in checkForHit incase there's an overlap when descendPiece calls it...
	canGoRight = true;
	
	checkForHit();

	if (dir == "left" && canGoLeft) active_piece_left -= box_dim;
	if (dir == "right" && canGoRight) active_piece_left += box_dim;
	
	active_piece.style.left = active_piece_left + "px";
	//piece_parts = active_piece.getElementsByTagName("SPAN");
	
	if (checkForHit()) landPiece();
}
   		
function rotatePiece() {
	var canRotate = true, cur_ac_left = active_piece_left;
   	cur_piece_state++;
   		
	if (cur_piece_state > 3) cur_piece_state = 0;
   		
     /*
     	can only do this now that i'm checking via the array rather than where the actual pieces are... 
     	
     	OK - so we rotate it 'behind the scenes', check if it's allowed to move, and if it is - display the change.
     	if not, go back to what it was...
     */
     
     canGoLeft = true;
     canGoRight = true;
     //document.getElementById("debug").innerHTML+="<br> cant go right <br>";
     //i should really get this to work by using checkForHit() i suppose...

     //need to fixed it so that it will move over if there's a piece to the right of it, rather than when it's just against the wall...
     
    for (var i=0; i < piece_parts.length; i++) {
     	var l = ((active_piece_left/box_dim) + pieces[cur_piece][cur_piece_state][i].x) +1;
     	//var t = ((active_piece_top/box_dim) + pieces[cur_piece][cur_piece_state][i].y);
     	if (l > grid_width) { // || grid[t][l] != "b") {
     		active_piece_left -= box_dim;
     	//} else if (grid[t][l] != "b"){
     		//active_piece_left -= box_dim;
     	}
	}
	
	canRotate = !checkForHit();
	
	if (canRotate) {
		//draw out the piece in it new orientation:

		for (var i=0; i < piece_parts.length; i++) {
			   piece_parts[i].style.top = (pieces[cur_piece][cur_piece_state][i].y*box_dim) + "px";
			   piece_parts[i].style.left = (pieces[cur_piece][cur_piece_state][i].x*box_dim) + "px";
		}
                
		active_piece.style.left = active_piece_left + "px";
	} else {
		//put it back.
		cur_piece_state--;
		active_piece_left = cur_ac_left;
		if (cur_piece_state < 0) cur_piece_state = 3;
   	}
}
   		
var high_part_for_drop = cur_part_for_drop = 0;
   		
function dropPiece() {
	clearInterval(game_int);
	
	checkForHit(); //so we get an up to date picture of the state of things
	high_part_for_drop = cur_part_for_drop;
	
	game_int = setInterval("descendPiece()", 10);
}
   		
function descendPiece() {
   	//var t = parseInt(active_piece.style.top);
	active_piece_top += box_dim;   	
	active_piece.style.top = active_piece_top + "px";
	   	
	//now check to see if it has hit something:
	   	
	if (checkForHit() == true) { //also takes into account hitting others rather than just the base...
		landPiece();
	}
}
            
function landPiece() {	
	clearInterval(game_int); //incase they'd used the drop
        
    //var t = parseInt(active_piece.style.top);
    //var l = parseInt(active_piece.style.left);
	   				   		
    //check to see if we have lost:
   		
   	if (active_piece_top < (box_dim*2)) { //should be bottom_most_edge < 0...
		checkForHighScore(); //endGame();
		return false;
   	}

   	//a point for landing a piece:
	score++;
   			
    for (var i=0; i < piece_parts.length; i++) {
        //so now remove the pieces from their parent piece and just append them to the game board (since there's no need for the div elements they're in hanging around doing nothing...)
		var new_piece_part = piece_parts[i].cloneNode(true);

      	var piece_top = active_piece_top+(pieces[cur_piece][cur_piece_state][i].y*box_dim); 
      	//(parseInt(piece_parts[i].style.top)+t);
      	var piece_left = active_piece_left+(pieces[cur_piece][cur_piece_state][i].x*box_dim);
      	//parseInt(piece_parts[i].style.left)+parseInt(active_piece.style.left);
         
         //add them to the array of what's where
		var row = (grid_height-1) - (piece_top/box_dim);
		var col = piece_left/box_dim;
                
		if (row > max_row) max_row = row;
                
		new_piece_part.style.top = piece_top + "px";
		new_piece_part.style.left = piece_left + "px"; 
                
		grid[row][col] = new_piece_part; //was f for filled, now a pointer to the html elements so it can be removed easily...

       	document.getElementById("play_area").appendChild(new_piece_part);  
	}
            
	document.getElementById("play_area").removeChild(active_piece);
            
	//so set where the highest point is (since there's no point iterating through the whole array every time)

	//check for a line:
   		
	var lines_cleared = 0;
	
	for (var i=max_row; i >= 0; i--) { //starting top down
		var found_row = true;
		for (var a=0; a < grid[i].length; a++) {
			if (grid[i][a] == "b") {
				found_row = false;
				break;	
			}	
		}
		
		if (found_row) {
			lines_cleared++;
			//handle stuff for deleting rows and adding points:
		
			//remove the elements:
			for (var a=0; a < grid[i].length; a++) document.getElementById("play_area").removeChild(grid[i][a]);
			
			//now remove their reference in the array
			grid.splice(i, 1);
		
			//now make the array whole again:
			grid.push(new Array(grid_width));
			for (var a=0; a < grid[grid.length-1].length; a++) grid[grid.length-1][a] = "b";
		
		//now move everything above down one:
			for (var j=i; j < max_row; j++) { //grid.length previously
				for (var k=0; k < grid[j].length; k++) {
					if (grid[j][k] != "b") grid[j][k].style.top = (parseInt(grid[j][k].style.top) + box_dim) + "px";
				}
			}
		}
	}
	
	total_lines += lines_cleared;
	
	switch(lines_cleared) {
		case 1:
			score += 40;
			break;
		case 2:
			score += 100;
			break;
		case 3:
			score += 600;
			break;
		case 4:
			score += 1200;
			break;
	}
	
//if they've dropped it, then add the score (like tugga suggested):
	
	if (high_part_for_drop > 0) {
		score += (cur_part_for_drop - high_part_for_drop); //because it's actually backwards (origin is at the top...)
		//alert("high: " + high_part_for_drop + ", cur: " + cur_part_for_drop);
		high_part_for_drop = 0;	
	}
	
	level = Math.floor(total_lines/10);
	level++; //(so it's 1 based rather than 0 based...)
	if (level > old_level && interval > 0) interval -= 50; //since there aint much point going any lower than 0 :)
	
	//document.getElementById("level").innerHTML = level;
	document.getElementById("lines").innerHTML = total_lines + " Lines";
	document.getElementById("score").innerHTML = score;
	
	yankPiece();
	game_int = setInterval("descendPiece()", interval); 
	
	old_level = level;
}
   		
function checkForHit() {
	var res = false;
   	var bottom_most_edge = 0, left_most_edge = 100, right_most_edge = 0;
   		
	//piece_parts = active_piece.getElementsByTagName("SPAN"); //make sure we have an up to date 'map' of where the parts of the piece are
	
	for (var i=0; i < 4; i++) { //piece_parts.length
		//document.getElementById("debug").innerHTML+= i + "<br>";
		//get outer edges to make sure they haven't hit anything ( |_| but not top edge)
		
		var left_edge = (active_piece_left/box_dim) + pieces[cur_piece][cur_piece_state][i].x;
		var bottom_edge = (active_piece_top/box_dim) + pieces[cur_piece][cur_piece_state][i].y + 1;
		var right_edge = left_edge + 1;
		
		//may as well do the checking here:
		if (bottom_edge > 0) { // || 
			if (bottom_edge == grid_height) res = true;
			if (left_edge == 0) canGoLeft = false;
			if (right_edge == grid_width) canGoRight = false;
                    
			//stopping it colliding with other pieces:
			
			if (bottom_edge < grid_height) {
				if (grid[(grid_height-1)-bottom_edge][left_edge] != "b") res = true;
				
				if (bottom_edge > 1) {
					if (left_edge > 0) {
						if (grid[grid_height-bottom_edge][left_edge-1] != "b") canGoLeft = false;
					 }
				
					if (right_edge < grid_width) {
						if (grid[grid_height-bottom_edge][right_edge] != "b") canGoRight = false;
					}
				}
			}
		}
		//alert(grid_height);
		//could really just use Math.max()...
		if (left_edge < left_most_edge) left_most_edge = left_edge;
		if (right_edge > right_most_edge) right_most_edge = right_edge;
		if (bottom_edge > bottom_most_edge) bottom_most_edge = bottom_edge;
		
	}
   		
   	cur_part_for_drop = bottom_most_edge; //if (bottom_most_edge > 0) 
   		
   	if (bottom_most_edge >= grid_height) res = true;
   		   		
   	return res;
}
   		
//building in a work around for the multiple event safari bug...
   		
var last_key = null;

function handleKeyPress(e) {
	e = e.keyCode; 
	if (e != last_key) {
		//alert(e);
		switch (e) {
			case 37:
			   if (!isPaused) movePiece('left');
			   break;
			case 39:
			   if (!isPaused) movePiece('right');
			   break;
			case 38:
			   if (!isPaused) rotatePiece();
			   break;
			case 40:
				if (!isPaused) dropPiece();
				break;
			case 80:
				pauseGame(true);
				break;
			case 81:
				showGrid();
				break;
		}
	} 
	last_key = e;
   		
	setTimeout(function(){last_key = null;}, 50);
	return false;
}
   		
var game_int;
   		
function playGame() {
	//delete everything incase we're starting again:
   	
	document.getElementById("play_area").innerHTML = "";
	document.getElementById("next_piece").innerHTML = "";
	
	document.getElementById("score").innerHTML = "0";
	//document.getElementById("level").innerHTML = "1";
	
	//document.getElementById("masker").style.display = "none";
	document.getElementById("start_game").style.display = "none";
	document.getElementById("pause_game").style.display = "none";
	document.getElementById("end_game").style.display = "none";
	//document.getElementById("high_score_list").style.display = "none";
	document.getElementById("game").style.backgroundImage = "url(ui/backs/regular.png)";
	
	if (debris > 0) {
		makeDebris();
		max_row = debris; //obvious point here, but i'd forgot to do this and introduced a rather annoying bug.
	}
	
	score = 0;
	interval = init_interval; //interval is what is decremented, and init_interval is what we go back to when we start again...
	
	makePiece();
	yankPiece();
	//document.getElementById("next_piece").style.visibility = "visible";
	
	game_int = setInterval("descendPiece()", interval);	
	
	//so keypress can be attached to contentEditable divs, but not the whole document, it seems.
	//I wonder if giving the main play area the focus and attaching a keypress event listener to that would work...
	document.addEventListener("keydown", handleKeyPress, false);
	isPlaying = true;
}

var isPaused = false;
   		
function pauseGame(toshow) { //toshow is used to tell the function if we want to see the game paused message or not (not desirable when showing the game over screen, hence the option)
	if (isPlaying) {
		if (!isPaused) {
			clearInterval(game_int);
			if (toshow) {
				//document.getElementById("masker").style.display = "block";
				document.getElementById("pause_game").style.display = "block";
				document.getElementById("play_area").style.display = "none";
				document.getElementById("game").style.backgroundImage = "url(ui/backs/pause_or_splash.png)";
			}
		} else {
			game_int = setInterval("descendPiece()", interval);
			if (toshow) {
				//document.getElementById("masker").style.display = "none";
				document.getElementById("pause_game").style.display = "none";
				document.getElementById("play_area").style.display = "block";
				document.getElementById("game").style.backgroundImage = "url(ui/backs/regular.png)";
			}
		}
		isPaused = !isPaused;
	}
}
   		
function endGame(toshow) {
	(isPaused) ? pauseGame(true) : pauseGame(false);
	
	//document.getElementById("masker").style.display = "block";
   	if (toshow) {
   		document.getElementById("play_area").style.display = "none";
   		document.getElementById("game").style.backgroundImage = "url(ui/backs/pause_or_splash.png)";
   		document.getElementById("start_game").style.display = "block";
   		//document.getElementById("end_game").style.display = "block";
	}

	document.getElementById("next_piece").innerHTML = "";

	//now reset everything: i'm debating whether or not to just reload the page rather than doing this... hmm...
	lines_cleared = 0;
	level = 1;
	level = old_level = total_lines = max_row = 0; //points done as suggested by tugga from thedashboarder.com
	clearInterval(game_int);
	
	for (var i=0; i < grid.length; i++) {
		grid[i] = new Array(10);
		for (var a=0; a< grid[i].length; a++) grid[i][a] = "b"; //for blank, since they'll be holding pointers to html elements if not blank...
	}
	
	document.removeEventListener("keydown", handleKeyPress, false);
	last_key = null;
	isPaused = false;
	isPlaying = false;
}
   		
function checkForHighScore() {
	if (window.widget) {
		if (score > top_score) {
			top_score = score;
			widget.setPreferenceForKey(top_score,"top_score");
			widget.setPreferenceForKey(total_lines,"top_lines");
			document.getElementById("top_score").innerHTML = top_score;
			document.getElementById("top_lines").innerHTML = total_lines;
		} else {
			document.getElementById("start_game").style.display = "block";
		}
	}
	
	endGame(true);
}
   		
function toggleSettings() {
	var g = document.getElementById("game");
	var p = document.getElementById("prefs");

	
	if (g.style.display == "block") {
		g.style.display = "none";
		p.style.display = "block";
		if (isPlaying && !isPaused) pauseGame(true);
   
		if (window.widget) widget.prepareForTransition("ToBack");
		//getHighScores();
	} else {
		g.style.display = "block";
		p.style.display = "none";

		if (window.widget) widget.prepareForTransition("ToFront");
	}

	if (window.widget) setTimeout("widget.performTransition()", 0);
}
   		
function doneSettings() {
	//set the prefs:
	debris = document.getElementById("debris").value;

	//now some checks
	if (isNaN(debris)) {
		debris = 0;
	} else {
		if (debris > 9) debris = 9; //can't happen because of the maxlength attribute, but might as well cover it :/
	}
	
	document.getElementById("debris").value = debris; //superfluous if there was no problem with the value...
	var dif = document.getElementById("difficulty");
	init_interval = dif.options[dif.options.selectedIndex].value;
	if (!isPlaying) document.getElementById("level").src = "ui/level_" + dif.options[dif.options.selectedIndex].text.toLowerCase() + ".png";
	
	if (window.widget) {
		widget.setPreferenceForKey(init_interval, "difficulty");
		widget.setPreferenceForKey(debris, "debris");
	}
	
	toggleSettings();
}
   		
function init() {
	document.getElementById("game").style.display = "block";
	document.getElementById("start_game").style.display = "block";
 
//now get the user preferences:
	if (window.widget) {
		init_interval = widget.preferenceForKey("difficulty") || 500; //initial interval	           
		debris = widget.preferenceForKey("debris") || 0;
		top_score =widget.preferenceForKey("top_score") || 0;
                top_lines = widget.preferenceForKey("top_lines") || 0;
	}

	document.getElementById("debris").value = debris;
	document.getElementById("top_score").innerHTML = top_score;
	document.getElementById("top_lines").innerHTML = total_lines + " Lines";
	
	var dif = document.getElementById("difficulty");
	for (var i=0; i < dif.options.length; i++) {
		if (dif.options[i].value == init_interval) {
			dif.options.selectedIndex = i;
			document.getElementById("level").src = "ui/level_" + dif.options[i].text.toLowerCase() + ".png";
			break;
		}
	}
}

if (window.widget) {
	widget.onhide = function() {
		if (!isPaused) pauseGame(true);
	}
}

window.onload = init;
	 //window.onunload = setHighScores;